# **CPU** 작동 원리

**중앙처리장치(CPU)** 는 컴퓨터의 모든 시스템을 제어, 처리하는 가장 핵심적인 장치로, 다양한 입력 장치로부터 정보를 입력받아 처리한 후, 그 결과를 출력장치로 보내는 일련의 과정을 제어하고 조정하는 일을 수행한다.  

## CPU의 구성요소

### 제어장치(Control Unit, CU)
컴퓨터 시스템의 작동을 통제하고 지시하는 장치이다.
- 기억 장치로부터 프로그램 명령을 순차적으로 꺼내 해독하고, 해석에 따라서 명령어 실행에 필요한 제어 신호를 기억장치, 연산장치 등으로 보낸다.
- `프로그램카운터(PC)`, `명령 해독기`, `부호기`, `명령 레지스터` 등으로 구성된다.

### 연산장치(Arithmetic Logic Unit, ALU)
명령어를 실행하기 위한 마이크로 연산을 수행하는 장치이다.
- 연산에 필요한 자료를 입력받아 산술, 논리, 관계, 이동 등 다양한 연산을 수행한다.
- 연산에 필요한 데이터는 레지스터에서 가져오고 연산이 끝나면 다시 레지스터로 돌려준다.

### 레지스터(Register)
CPU 내에 있는 고속 기억 장치이다.
- 명령어 주소, 코드, 연산에 필요한 데이터, 연산 결과 등을 임시로 저장한다.
- 레지스터는 메모리 계층의 최상위에 위치하며 가장 빠른 속도로 접근 가능한 메모리이다.
- 용도에 따라 범용 레지스터와 특수 목적 레지스터로 구분된다. 아래는 특수 목적 레지스터이다.
  - MAR(메모리 주소 레지스터): 읽기와 쓰기 연산을 수행할 주기억장치 주소를 저장한다. 
  - PC(프로그램 카운터): 다음에 실행될 명령어의 주소를 저장한다.
  - SP(스택 포인터): 스택의 최상위 주소를 저장한다.
  - IX(인덱스 레지스터): 인덱스 주소 지정 방식에서 인덱스를 저장한다.
  - IR(명령어 레지스터): 명령어를 호출해서 해독하기 위해 현재 명령어를 임시로 저장한다.
  - MBR(메모리 버퍼 레지스터): 주기억장치의 내용을 임시로 저장한다.
  - AC(누산기): 산술 논리 장치의 연산 결과를 임시로 저장한다.
  - PSR(프로그램 상태 레지스터): CPU의 현재 상태 정보를 저장한다.

## CPU의 연산
CPU의 연산은 `Fetch`, `Decode`, `Execute`, `Writeback`의 순서로 반복된다.

1. **Fetch(인출)**: 메모리상의 프로그램 카운터(PC)가 가리키는 명령어를 CPU로 인출하여 적재한다.
2. **Decode(해석)**: 명령어의 종류와 타겟 등을 해석하여 결정한다.
3. **Execute(실행)**: 해석된 명령어에 따라 데이터에 대한 연산을 수행한다.
4. **Writeback(쓰기)**: 수행 완료된 데이터를 메모리에 기록한다.

## CPU 동작과정

<img alt="CPU동작과정" src="https://user-images.githubusercontent.com/70997596/207575264-c0d5a22f-c6b9-4bef-bda4-7899ef4754c9.jpeg" width="380px">

1. 처리해야 할 데이터를 주기억장치의 `RAM`에서 불러와 제어장치의 `레지스터1`에 전달한다.
2. 제어장치는 연산 코드를 해석하고 수행할 연산을 결정해서 `연산장치(ALU)`에게 전달한다. 
   1. `RAM`에서 프로그램 카운터(PC)에 있는 실행될 명령어 주소를 참조하여 명령어를 명령어 레지스터에 넣는다.
   2. 가져온 명령어는 연산코드와 데이터로 분리되어, 연산코드는 명령어 레지스터로 넘어가고, 나머지 데이터는 기억장치의 주소 레지스터를 통해 주기억장치로 넘어간다. 
   3. 프로그램 카운터는 다음에 실행할 명령어 주소를 바꾼다. 
   4. 명령어 해석기에 들어간 연산코드는 해석되어 무슨 연산을 할지 결정한 후 연산장치에 넘어간다. 
   5. 연산장치가 연산을 수행하며, 앞서 주기억장치로 넘어간 데이터를 사용한다.   
3. `연산장치(ALU)`가 연산을 실행한다.
4. `RAM`으로 연산 결과를 전송한다.

<img width="420" alt="스크린샷 2022-12-14 오후 7 41 53" src="https://user-images.githubusercontent.com/70997596/207575454-a9e2c541-eca2-4579-ad81-9dbf788da1b7.png">

---

## Reference

📄 https://foxtrotin.tistory.com/144  
📕 컴퓨터 구조와 원리 (비주얼 컴퓨터 아키텍처), 신종홍 저, 한빛미디어, 2011  
📕 디지털논리와 컴퓨터 설계, Harris et al. (조영완 외 번역), 사이텍미디어, 2007,
